//
// PSoC 7セグメントLED４桁　シンプルクロック（時計）
//
// PIN PORT 	CONNECT
//	1	P07		抵抗を通してLED_DP(２桁目も同じ)
//	2	P05		抵抗を通してLED_F(２桁目はLED_C)
//	3	P03		抵抗を通してLED_D(２桁目はLED_A)
//	4	P01		抵抗を通してLED_B(２桁目はLED_E)
//	5	P27		(LED-COM6)
//	6	P25		LED-COM4
//	7	P23		LED-COM2
//	8	P21		
//	9	SMP		
//	10	P17		MiniProg-SCL/時刻あわせ＋
//	11	P15		MiniProg-SDA/時刻あわせ－
//	12	P13		
//	13	P11		MiniProg-SCLK/32.768kHz(---22pF---VDD)
//	14	VSS		GND(MiniProg-GND)
//	15	P10		MiniProg-SDATA/32.768kHz(---22pF---VDD)
//	16	P12		
//	17	P14		
//	18	P16		
//	19	XRES	MiniProg-XRES
//	20	P20		ADIN
//	21	P22		LED-COM1
//	22	P24		LED-COM3
//	23	P26		(LED-COM5)
//	24	P00		抵抗を通してLED_A(２桁目はLED_D)
//	25	P02		抵抗を通してLED_C(２桁目はLED_F)
//	26	P04		抵抗を通してLED_E(２桁目はLED_B)
//	27	P06		抵抗を通してLED_G(２桁目も同じ)
//	28	VDD		+5V
//	※ＬＥＤ２桁目は上下さかさまに取り付け
//
//
//
//


//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules


#pragma interrupt_handler Counter8_1_ISR  // ISR for the Counter8_1 module

/////////////////////////////////
// 設定値
/////////////////////////////////
#define KEY_REPEAT_TIME	20	//キーリピートが始まるまでの時間

/////////////////////////////////
// グローバル変数
/////////////////////////////////
unsigned char key_on = 0;
unsigned char sec = 0;
unsigned char min = 0;
unsigned char hour = 0;
unsigned char mode = 1;	//0:通常動作,1:時刻未設定


/////////////////////////////////
// 時間を進める
/////////////////////////////////
//分単位で進める
void time_p2(void)
{
	sec = 0;
	min++;
	if(min >= 60)
	{
		min = 0;
		hour++;
		if(hour >= 24)
		{
			hour = 0;
		}
	}
}
//秒単位で進める
void time_p(void)
{
	sec++;
	if(sec >= 60)
	{
		time_p2();
	}
}

/////////////////////////////////
// 時間を戻す
/////////////////////////////////
//分単位で戻す
void time_m2(void)
{
	sec = 59;
	if(min)
	{
		min--;
	}
	else
	{
		min = 59;
		if(hour)
		{
			hour--;
		}
		else
		{
			hour = 23;
		}
	}
}
//秒単位で戻す
void time_m(void)
{
	if(sec)
	{
		sec--;
	}
	else
	{
		time_m2();
	}
}



/////////////////////////////////
// 割り込み処理
/////////////////////////////////
void Counter8_1_ISR(void)
{
	static unsigned char t = 0;
	static unsigned char key0 = 0,key1 = 0,key2 = 0,key_old = 0;
	static unsigned char p = 0,m = 0;	//キーリピートチェック用
	unsigned char disp = 0;				//表示フラグ（表示値に変化があったとき１にする）
	t++;

	//キー入力チェック(時計あわせに使うのはP15,P17)
	//チャタリング防止のため、３回同じ値になったときだけ有効とする
	key2 = key1;
	key1 = key0;
	key0 = ~PRT1DR;
	if((key0 == key1) && (key1 == key2))
	{
		//立ち上がりチェック
		key_on |= (~key_old) & key0;
		key_old = key0;

		//継続時間チェック
		if(key0 & 0x80)
		{
			if((p < 255) && ((t & 0x0f) == 0))
			{
				p++;
			}
		}
		else
		{
			p = 0;
		}
		if(key0 & 0x20)
		{
			if((m < 255) && ((t & 0x0f) == 0))
			{
				m++;
			}
		}
		else
		{
			m = 0;
		}
	}

	//キー入力処理
	if(key_on & 0xa0)
	{
		t = 1;		//秒以下をリセット(0で秒が加算されてしまうので１にする)
		sec = 0;	//秒をリセット

		//時間加算または減算
		if(key_on & 0x80)
		{
			time_p2();	//加算
		}
		if(key_on & 0x20)
		{
			time_m2();	//減算
			sec = 0;
		}
		//表示指示
		disp = 1;

		//キー立ち上がり処理終了したのでキー立ち上がりフラグをクリア
		key_on = 0;
		//時間未設定モードを解除
		mode = 0;
	}
	//キーリピート処理
	if(p > KEY_REPEAT_TIME)
	{
		if((t & 3) == 0)
		{
			time_p2();	//加算
			disp = 1;	//表示指示
		}
	}
	if(m > KEY_REPEAT_TIME)
	{
		if((t & 3) == 0)
		{
			time_m2();	//減算
			sec = 0;
			disp = 1;	//表示指示
		}
	}

	if(mode)
	{
		//時刻未設定（未設定表示）
		if((t == 0) || (t == 128))
		{
			unsigned char pat = 0;
			//コロンは消しておく
			LED7SEG_1_DP(0,3);
			LED7SEG_1_DP(0,2);
			//「--:--」を部リンクさせる
			if(t)
				pat = 0x40;
			LED7SEG_1_PutPattern(pat,1);
			LED7SEG_1_PutPattern(pat,2);
			LED7SEG_1_PutPattern(pat,3);
			LED7SEG_1_PutPattern(pat,4);
		}
	}
	else
	{
		//時計通常処理（時間を進める＆コロンの点滅）
		if(!t)
		{
			time_p();	//時刻カウント
			disp = 1;	//表示指示
		}
		if((t == 0) || (t == 128))
		{
			//Colon blinking
			LED7SEG_1_DP(!t,3);
			LED7SEG_1_DP(!t,2);
		}
	}
	
	if(disp)
	{
		//時刻表示
		LED7SEG_1_DispInt(min,3,2);		//分
		LED7SEG_1_DispInt(hour,1,2);	//時間
	}
}


void main(void)
{
	// Insert your main routine code here.

	Counter8_1_WritePeriod(32768/256-1);	//set the period to 32768/512
	Counter8_1_EnableInt();				//Enable the interrupt
	Counter8_1_Start();					//start the counter

	LED7SEG_1_Start();						//Enable display  
	M8C_EnableGInt;							//Enable IRQ   
     
	//キーバッファ初期化
	key_on = 0;

	LED7SEG_1_Dim(0);	//輝度を暗くする
	LED7SEG_1_Dim(1);	//輝度をもどす

	while(1)
	{
	}
}
