//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

#pragma interrupt_handler Counter16_1_ISR  // ISR for the Counter16_1 module

/////////////////////////////////
// グローバル変数
/////////////////////////////////
volatile unsigned char t0,t1;

/////////////////////////////////
// 割り込み処理
/////////////////////////////////
void Counter16_1_ISR(void)
{
	t0++;
	if(t0 >= 60)
	{
		t0 = 0;
		t1++;
		if(t1 >= 100)
		{
			t1 = 0;
		}
	}
}


void main(void)
{
	// M8C_EnableGInt ; // Uncomment this line to enable Global Interrupts
	// Insert your main routine code here.

	Counter16_1_WritePeriod(32768/1-1);	//set the period to 32768/1
	Counter16_1_EnableInt();				//Enable the interrupt
	Counter16_1_Start();					//start the counter

	LED7SEG_1_Start();						//Enable display  
	M8C_EnableGInt;							//Enable IRQ   
     
//	LED7SEG_1_Dim(0);	//輝度を暗くする
//	LED7SEG_1_Dim(1);	//輝度標準

	for(;;)
	{
		static unsigned char t_old = 255;
		if(t0 != t_old)
		{
			t_old = t0;
			LED7SEG_1_DispInt(t1,1,2);	//上位２桁
			LED7SEG_1_DispInt(t0,3,2);	//下位２桁
		}
	}
}
